//******************************************
// file			: ADC_Function.c
// version		: V1.0
// brief		: ADC related functions
// note			: ADC related functions are gathered in this subroutine
//******************************************   
#include "ADC_Function.h"
#include "MQ6821.h"

void adc_config_set(unsigned char AMD,unsigned char AINEN,unsigned char SAIN,unsigned char ACK,unsigned char VREF)
{
    ADCCR1.byte = AMD*32 + AINEN*16 + SAIN;
	ADCCR2.byte = ACK;
    ADCVRF.byte = VREF;   
    
}
void adc_start()
{
	ADCCR1.byte =  ADCCR1.byte | 0x80;
}
void adc_stop()
{
	ADCCR1.byte =  ADCCR1.byte & 0x1F;
}
unsigned int adc_result_read()
{	
	
	TYPE_WORD ADC_READ;
	ADC_READ.byte[0] = ADCDRL.byte;
	ADC_READ.byte[1] = ADCDRH.byte;
	return ADC_READ.word;
	
}
